/*
LICENSE:
Sample code provided with the article may be copied/duplicated and modified
in any form as long as this copyright is prepended unmodified.
Code are proof of concept and the author can and must not be made
responsible for any damage/data loss.
Use this code at your own risk.

                                            crazylord / CNS
*/

#include <aclapi.h>
#include "callgates.h"

EXPLICIT_ACCESS          Access;
UNICODE_STRING           physmemString;
WCHAR                    physmemName[] = L"\\device\\physicalmemory";
OBJECT_ATTRIBUTES        ObAttributes;
NTSTATUS                 ntS;
HANDLE                   Section = NULL;
DWORD                    Res;
PACL                     OldDacl=NULL, NewDacl=NULL;
PSECURITY_DESCRIPTOR     SecDesc=NULL;

PHYSICAL_ADDRESS getPhysAdd(ULONG VirtualAddress) {
	PHYSICAL_ADDRESS  add;

	if (VirtualAddress < 0x80000000L || VirtualAddress >= 0xA0000000L)
		add.QuadPart = (ULONGLONG) VirtualAddress & 0xFFFF000;
	else
		add.QuadPart = (ULONGLONG) VirtualAddress & 0x1FFFF000;

	return(add);
}

int installCallgate(HANDLE section, DWORD function, int nro, int param_count)
{
    NTSTATUS             status;
    KGDTENTRY            gdt;
    DWORD                size;
    PCALLGATE_DESCRIPTOR cg_descriptor;
    
  asm  ("sgdt %0" : "=m" (gdt) : );
  
  printf("\n[+] GDT information\n");
  printf("[+] gdt BaseHigh: \t\t [ 0x%08x ]\n", gdt.BaseHigh);
  printf("[+] gdt BaseLow: \t\t [ 0x%08x ]\n", gdt.BaseLow);
  printf("[+] gdt LimitLow: \t\t [ 0x%08x ]\n", gdt.LimitLow);
  
  GdtMap[nro].pAddress = getPhysAdd(MAKE_DWORD(gdt.BaseLow, gdt.BaseHigh));
  
  printf("[+] gdtMap.pAddress: \t\t [ 0x%08x ]\n", GdtMap[0].pAddress);
  
   size = gdt.LimitLow;
   status = NtMapViewOfSection(section, (HANDLE) -1, &GdtMap[nro].MappedAddress,
                            0L, size, &GdtMap[nro].pAddress, &size, ViewShare,
                            0, PAGE_READWRITE);

   if (status != STATUS_SUCCESS || !GdtMap[nro].MappedAddress) {
      return(0);
   }

   GdtMap[nro].LastEntry = gdt.LimitLow & 0xFFF8; // offset to last entry
   for(cg_descriptor = (struct _CALLGATE_DESCRIPTOR *) ((DWORD)GdtMap[nro].MappedAddress + GdtMap[nro].LastEntry),
       GdtMap[nro].Desc=NULL;
       (DWORD) cg_descriptor > (DWORD) GdtMap[nro].MappedAddress;
       cg_descriptor--) {
      
      if(cg_descriptor->present == 0){
         cg_descriptor->offset_0_15  = (WORD) (function & 0xFFFF);
         cg_descriptor->selector     = 8;
         cg_descriptor->param_count  = (UCHAR) param_count;		// Parameters;
         cg_descriptor->some_bits    = 0;
         cg_descriptor->type         = 12;     // 32-bits callgate junior :>
         cg_descriptor->app_system   = 0;      // A segment descriptor
         cg_descriptor->dpl          = 3;      // Ring 3 code can call
         cg_descriptor->present      = 1;
         cg_descriptor->offset_16_31 = (WORD) (function >> 16);
         GdtMap[nro].Desc = cg_descriptor;
         break;
      }
   }

   if (GdtMap[nro].Desc == NULL) {
		printf("ERROR: There is no any free entry\n");
		return(0);
   }

   GdtMap[nro].Segment = ((WORD) ((DWORD) cg_descriptor - (DWORD) GdtMap[nro].MappedAddress))|3;
   return(1);
}

int UninstallCallgate(DWORD function, int nro) {
   PCALLGATE_DESCRIPTOR cg_descriptor;

   for(cg_descriptor = (struct _CALLGATE_DESCRIPTOR *) ((DWORD) GdtMap[nro].MappedAddress + GdtMap[nro].LastEntry);
       (DWORD) cg_descriptor > (DWORD) GdtMap[nro].MappedAddress;
      cg_descriptor--) {
      
      if((cg_descriptor->offset_0_15 == (WORD) (function & 0xFFFF))
         && cg_descriptor->offset_16_31 == (WORD) (function >> 16)){
         memset(cg_descriptor, 0, sizeof(CALLGATE_DESCRIPTOR));
         return(1);
      }
   }
   NtUnmapViewOfSection((HANDLE) -1, GdtMap[nro].MappedAddress);
   return(0);
}


BOOL LocateNtdllEntryPoints()
{
	if( !(RtlInitUnicodeString = (void (__stdcall *)(PUNICODE_STRING,PCWSTR)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"RtlInitUnicodeString" )) ) {

		return FALSE;
	}

	if( !(NtOpenSection = (long (__stdcall *)(void ** ,unsigned long,struct _OBJECT_ATTRIBUTES *)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"NtOpenSection" )) ) {

		return FALSE;
	}

	if( !(NtClose = (void (__stdcall *)(void *)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"NtClose" )) ) {

		return FALSE;
	}

	if( !(NtUnmapViewOfSection = (long (__stdcall *)(void *,void *)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"NtUnmapViewOfSection" )) ) {

		return FALSE;
	}

	if( !(NtMapViewOfSection = (long (__stdcall *)(void *,void *,void ** ,unsigned long,unsigned long,union _LARGE_INTEGER *,unsigned long *,enum _SECTION_INHERIT,unsigned long,unsigned long)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"NtMapViewOfSection" )) ) {

		return FALSE;
	}
	

	if( !(RtlNtStatusToDosError = (unsigned long (__stdcall *)(long)) GetProcAddress( GetModuleHandle("ntdll.dll"),
			"RtlNtStatusToDosError" )) ) {

		return FALSE;
	}
        

	return TRUE;
}

BOOL ChangeDevPhysicalMemRights(){
	memset(&Access, 0, sizeof(EXPLICIT_ACCESS));
	//
	// Load the entry points
	//
	if( !LocateNtdllEntryPoints() ) {
		printf("ERROR: Unable to locate NTDLL entry points\n");
	  goto cleanup;
	}

	RtlInitUnicodeString( &physmemString, physmemName );	
	InitializeObjectAttributes(&ObAttributes,
							  &physmemString,
							  OBJ_CASE_INSENSITIVE | OBJ_KERNEL_HANDLE,
							  NULL,
							  NULL);

	/////////////////////
	// 1 - Open a handle to \Device\PhysicalMemory
	ntS = NtOpenSection(&Section, WRITE_DAC | READ_CONTROL, &ObAttributes);
	if (ntS != STATUS_SUCCESS) {
		printf("ERROR: Error opening Section\n");
		goto cleanup;
	}

	/////////////////////
	// 2 - Get a copy of the securiy descriptor
	Res = GetSecurityInfo(Section, SE_KERNEL_OBJECT, 
						  DACL_SECURITY_INFORMATION, NULL, NULL, &OldDacl,
						  NULL, &SecDesc);
	if (Res != ERROR_SUCCESS) {
		printf("ERROR: Error getting security descriptor\n");
		goto cleanup;
	}

	Access.grfAccessPermissions = SECTION_MAP_WRITE;
	Access.grfAccessMode        = GRANT_ACCESS;
	Access.grfInheritance       = NO_INHERITANCE;
	Access.Trustee.MultipleTrusteeOperation = NO_MULTIPLE_TRUSTEE;
	// Change this information to enable another group or user
	Access.Trustee.TrusteeForm  = TRUSTEE_IS_NAME;
	Access.Trustee.TrusteeType  = TRUSTEE_IS_USER;
	Access.Trustee.ptstrName = "CURRENT_USER";

	/////////////////////
	// 3 - Add write access ACE to ACL
	Res = SetEntriesInAcl(1, &Access, OldDacl, &NewDacl);
	if (Res != ERROR_SUCCESS) {
		printf("ERROR: Error creating the new ACL\n");
		goto cleanup;
	}

	/////////////////////
	// 4 - Update the security descriptor
	Res = SetSecurityInfo(Section, SE_KERNEL_OBJECT,
						  DACL_SECURITY_INFORMATION, NULL, NULL, NewDacl, 
						  NULL);
	if (Res != ERROR_SUCCESS) {
		printf("ERROR: Error updating ACL\n");
		goto cleanup;
	}

	/////////////////////
	// 5 - Close the section
	if (Section)
		NtClose(Section);

	/////////////////////
	// Once the write access was added, we try to open a new section to do that
	// If there is no problem, the physical memory can be written.
	ntS = NtOpenSection(&Section, SECTION_MAP_READ|SECTION_MAP_WRITE, &ObAttributes);

	if (ntS != STATUS_SUCCESS) {
		if (ntS == STATUS_ACCESS_DENIED) {
			printf("ERROR: access denied to open \\Device\\PhysicalMemory for r/w\n");
			goto cleanup;
		}
		else {
			printf("ERROR: Error opening NtOpenSection\n");
			goto cleanup;
	   }
	}

	//CALLGATE Installation
	if (!installCallgate(Section, (DWORD) RestoreSdtPtrs, 0, 0)){
		printf("ERROR: Callgate Not Installed\n");
		goto cleanup;
	}

	/////////////////////
	// 5 - Close the section
	if (Section)
		NtClose(Section);

	return 1;
cleanup:
	/////////////////////
	// Close the section opened for writing
	if (Section)
		NtClose(Section);
	if (SecDesc)
		LocalFree(SecDesc);
	return 0;
}
